/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.entity;

import com.minecraftabnormals.neapolitan.core.other.NeapolitanTags;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanEntities;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanSoundEvents;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChimpanzeeEntity
extends AnimalEntity
implements IAngerable {
    private static final DataParameter<Integer> ANGER_TIME = EntityDataManager.func_187226_a(ChimpanzeeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CHIMPANZEE_TYPE = EntityDataManager.func_187226_a(ChimpanzeeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(ChimpanzeeEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final RangedInteger ANGER_RANGE = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private UUID lastHurtBy;
    private int attackTimer;
    private float climbAnim;
    private float prevClimbAnim;

    public ChimpanzeeEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANGER_TIME, (Object)0);
        this.field_70180_af.func_187214_a(CHIMPANZEE_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.func_233682_c_(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199805_a(NeapolitanTags.Items.CHIMPANZEE_TEMPTATION_ITEMS), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, arg_0 -> ((ChimpanzeeEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new ResetAngerGoal((MobEntity)this, true));
    }

    protected void func_70619_bc() {
        this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        if (this.func_233678_J__()) {
            this.field_70718_bc = this.field_70173_aa;
        }
        super.func_70619_bc();
    }

    public boolean func_70652_k(Entity entityIn) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.field_70146_Z.nextInt((int)f) : f;
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f1);
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new ClimberPathNavigator((MobEntity)this, worldIn);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        this.prevClimbAnim = this.climbAnim;
        this.climbAnim = this.isClimbing() ? Math.min(this.climbAnim + 1.0f, 4.0f) : Math.max(this.climbAnim - 1.0f, 0.0f);
    }

    public void func_233629_a_(LivingEntity entity, boolean isFlying) {
        double d2;
        double d1;
        this.field_184618_aE = this.field_70721_aZ;
        double d0 = this.func_226277_ct_() - this.field_70169_q;
        float f = MathHelper.func_76133_a((double)(d0 * d0 + (d1 = this.isClimbing() ? this.func_226278_cu_() - this.field_70167_r : 0.0) * d1 + (d2 = this.func_226281_cx_() - this.field_70166_s) * d2)) * 4.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.field_70721_aZ += (f - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_213295_a(BlockState state, Vector3d motionMultiplierIn) {
        if (!state.func_203425_a(Blocks.field_196553_aF)) {
            super.func_213295_a(state, motionMultiplierIn);
        }
    }

    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getClimbingAnimationScale(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevClimbAnim, (float)this.climbAnim) / 4.0f;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setTypeForPosition(this, (IWorld)worldIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void setTypeForPosition(ChimpanzeeEntity entity, IWorld worldIn) {
        if (worldIn.func_226691_t_(this.func_233580_cy_()).getRegistryName().func_110623_a().contains("rainforest")) {
            entity.setChimpanzeeType(1);
        } else if (worldIn.func_226691_t_(this.func_233580_cy_()).getRegistryName().func_110623_a().contains("bamboo")) {
            entity.setChimpanzeeType(2);
        } else {
            entity.setChimpanzeeType(0);
        }
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public double func_70033_W() {
        return this.func_70631_g_() ? -0.05 : -0.3;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return AnimalEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.func_233678_J__() ? (SoundEvent)NeapolitanSoundEvents.ENTITY_CHIMPANZEE_ANGRY.get() : (SoundEvent)NeapolitanSoundEvents.ENTITY_CHIMPANZEE_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)NeapolitanSoundEvents.ENTITY_CHIMPANZEE_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)NeapolitanSoundEvents.ENTITY_CHIMPANZEE_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a((SoundEvent)NeapolitanSoundEvents.ENTITY_CHIMPANZEE_STEP.get(), 0.3f, 1.0f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    public boolean isClimbing() {
        return !this.field_70122_E && this.isBesideClimbableBlock();
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(NeapolitanTags.Items.CHIMPANZEE_BREEDING_ITEMS);
    }

    public ChimpanzeeEntity func_241840_a(ServerWorld world, AgeableEntity ageableEntity) {
        ChimpanzeeEntity baby = (ChimpanzeeEntity)((EntityType)NeapolitanEntities.CHIMPANZEE.get()).func_200721_a((World)world);
        this.setTypeForPosition(baby, (IWorld)this.func_130014_f_());
        return baby;
    }

    public int func_230256_F__() {
        return (Integer)this.field_70180_af.func_187225_a(ANGER_TIME);
    }

    public void func_230260_a__(int time) {
        this.field_70180_af.func_187227_b(ANGER_TIME, (Object)time);
    }

    public int getChimpanzeeType() {
        return (Integer)this.field_70180_af.func_187225_a(CHIMPANZEE_TYPE);
    }

    public void setChimpanzeeType(int type) {
        this.field_70180_af.func_187227_b(CHIMPANZEE_TYPE, (Object)type);
    }

    public UUID func_230257_G__() {
        return this.lastHurtBy;
    }

    public void func_230259_a_(UUID target) {
        this.lastHurtBy = target;
    }

    public void func_230258_H__() {
        this.func_230260_a__(ANGER_RANGE.func_233018_a_(this.field_70146_Z));
    }
}

